﻿# DFS auf 2 Member-Server installieren
$FS = @{
Name = 'FS-DFS-Namespace'
IncludeManagementTools = $True
}
Install-WindowsFeature @FS -ComputerName SRVFILE
Install-WindowsFeature @FS -ComputerName SRVDB

# Ordner und Freigabe erstellen auf SRVFILE und SRVDB
$SB = {
New-Item -Path C:\DFSShare -ItemType Directory -Force |
Out-Null
New-SmbShare -Name DFSShare C:\DFSShare -FullAccess Jeder
}
Invoke-Command -ComputerName SRVFILE, SRVDB -ScriptBlock $SB |
Out-Null

# Erstellen einen DFS Stamm der zuerst auf die Freigabe auf Server SRVFILE verweist
$ST = @{
Path = '\\dwp.local\DFSShare'
TargetPath = '\\SRVFILE\DFSShare'
Type = 'DomainV2'
Description = 'DFS-Stamm'
}
New-DfsnRoot @ST

# Erstellen ein weiteres Ziel für den DFS-Stamm auf SRVDB
$ST2 = @{
Path = '\\DWP.local\DFSShare'
TargetPath = '\\SRVDB\DFSShare'
}
New-DfsnRootTarget @ST2| Out-Null
# Prüfen die DFSShares
Get-DfsnRootTarget -Path \\dwp.local\DFSShare

# Erstellen noch einen Ordner und Freigabe auf SRVFILE für die physischen Daten
$SB = {
New-Item -Path C:\IT2 -ItemType Directory | Out-Null
New-SmbShare -Name 'ITData' -Path C:\IT2 -FullAccess Jeder
# Erstellen dort eine Datei
'Root' | Out-File -FilePath C:\IT2\Testdatei.txt
}
Invoke-Command -ScriptBlock $SB -Computer SRVFILE | Out-Null

# Erstellen nun einen Ordner und Freigabe auf SRVDB für die physischen Daten
$DB = {
New-Item -Path C:\IT2 -ItemType Directory | Out-Null
New-SmbShare -Name 'ITData' -Path C:\IT2 -FullAccess Jeder
'Root' | Out-File -FilePath c:\IT2\Root.Txt
}
Invoke-Command -ScriptBlock $DB -Computer SRVDB | Out-Null

# Erstellen ein DFS-Namespace und fügen die Freigaben beider Server hinzu:
$ST3 = @{
Path = '\\dwp.local\DFSShare\IT\ITData'
TargetPath = '\\SRVFILE\ITData'
EnableTargetFailback = $true
Description = 'IT-Daten'
}
New-DfsnFolder @ST3 | Out-Null
# Das Gleiche für den Server SRVDB aber ohne TargetFailback:
$ST4 = @{
Path = '\\dwp.local\DFSShare\IT\ITData'
TargetPath = '\\SRVDB\ITData'
}
New-DfsnFolderTarget @ST4 | Out-Null

# Prüfen der Hierarchie
Get-ChildItem -Path \\DWP.local\DFSShare\IT -Recurse

# Installieren das Replikation Feature auf beiden Servern
$SB = {
$REP = @{
Name ='FS-DFS-Replication'
IncludeManagementTools = $true
}
Add-WindowsFeature @REP
}
$ICHT = @{
ScriptBlock = $SB
ComputerName = 'SRVFILE', 'SRVDB'
}
Invoke-Command @ICHT | Format-Table -Property PSComputername,FeatureResult, Success

# Aktivieren der administrativen Freigaben
$SB2 = {
$SCHT = @{
AutoShareServer = $true
AutoShareWorkstation = $true
Confirm = $false
}
Set-SmbServerConfiguration @SCHT
"Neustart von LanmanServer auf $(hostname)"
Stop-Service -Name LanManServer -Force
Start-Service -Name LanManServer
}
$CN = @('SRVFILE', 'SRVDB')
Invoke-Command -ScriptBlock $SB2 -ComputerName $CN

# Erstellen der Replikationsgruppe namens DFSShareRG
$RG = @{
GroupName = 'DFSShareRG'
DomainName = 'DWP.local'
Description = 'Replikationsgruppe für Freigaben auf SRVFILE, SRVDB'
}
New-DfsReplicationGroup @RG | Out-Null

# Replikationsgruppe prüfen
Get-DfsReplicationGroup -DomainName DWP.local | Format-Table

# Der Replikationsgruppe DFSSHareRG die Mitglieder hinzufügen und zwar SRVFILE und SRVDB
$MTG = @{
GroupName = 'DFSShareRG'
Description = 'IT-Daten auf SRVFILE und SRVDB'
ComputerName = ('SRVFILE','SRVDB')
DomainName = 'DWP.local'
}
Add-DfsrMember @MTG

# Fügen dem DFS-N Ordner ITData die Replikationsgruppe DFSShareRG hinzu
$DRG = @{
GroupName = 'DFSShareRG'
FolderName = 'ITData'
Domain = 'DWP.local'
Description = 'IT-Daten auf SRVFILE und SRVDB'
DfsnPath = '\\DWP.local\DFSShare\IT\ITData'
}
New-DfsReplicatedFolder @DRG

# Mitgliedschaftseinstellungen für die Replikationsgruppe DFSShareRG setzen
$MIT1 = @{
GroupName = 'DFSShareRG'
FolderName = 'ITData'
ComputerName = 'SRVFILE'
ContentPath = 'C:\IT2'
PrimaryMember = $true
Force = $true
}
Set-DfsrMembership @MIT1 | Out-Null
$MIT2 = @{
GroupName = 'DFSShareRG'
FolderName = 'ITData'
ComputerName = 'SRVDB'
ContentPath = 'C:\IT2'
PrimaryMember = $false
Force = $true
}
Set-DfsrMembership @MIT2 | Out-Null

# Mitgliedschaftseinstellungen der Replikationsgruppe FSShareRG anzeigen
Get-DfsrMembership -GroupName DFSShareRG -ComputerName SRVFILE, SRVDB |
Format-Table -Property GroupName, ComputerName, ComputerDomainName, ContentPath, Enabled

# Replikationsverbindung der Replikationsgruppe DFSShareRG hinzufügen 
$VRG = @{
GroupName = 'DFSShareRG'
SourceComputerName = 'SRVFILE'
DestinationComputerName = 'SRVDB'
Description = 'SRVFILE und SRVDB Verbindung'
DomainName = 'dwp.local'
}
Add-DfsrConnection @VRG | Out-Null

# DFSR-Mitgliedschaften abrufen
Get-DfsrMember | Format-Table -Property Groupname, DomainName,DNSName, Description

# DFSR-Konfiguration aktualisieren
Update-DfsrConfigurationFromAD -ComputerName SRVFILE,SRVDB

# Überprüfen alle Freigaben und die Inhalte der DFS-Freigabe
$Path = '\\dwp.local\DFSShare\IT\ITData'
$Path1 = '\\SRVFILE\ITDATA'
$Path2 = '\\SRVDB\ITDATA'
Get-ChiLditem -Path $Path
Get-ChiLditem -Path $Path1
Get-ChildItem -Path $Path2

# Erstellen zum Abschluss ein paar Dateien udn prüfen nochmals die Freigabe
1..50 | foreach { "TESTINHALT" |
Out-File \\dwp.local\DFSShare\IT\ITData\Check$_.txt}
$P = (Get-ChildItem -Path $Path | Measure-Object).count
$P1 = (Get-ChildItem -Path $Path1 | Measure-Object).count
$P2 = (Get-ChildItem -Path $Path2 | Measure-Object).count
"$P Objekte im DFS-Stamm"
"$P1 Objekte auf \\SRVFILE"
"$P2 Objekte auf \\SRVDB"
